% GNF demo for self-organization with 'X' letter shape

clear
NumSamples = 10000;
MaxNeurons = 50; % Maximum number of neurons in each graph

% The following values of the parameters are those considered in the
% original GNG paper by Fritzke (1995)
Lambda=100;
Epochs=2;
EpsilonB=0.2;
EpsilonN=0.006;
Alpha=0.5;
AMax=50;
D=0.995;

% Generate data ('M' letter shape)
Samples = GenerateSamplesImg('M_letter.bmp',NumSamples);
NumSteps = NumSamples*Epochs;

% GNF Training
[Model] = TrainGNF(Samples,MaxNeurons,Lambda,EpsilonB,EpsilonN,Alpha,AMax,D,NumSteps);

% Plot the Model
Handle = figure;
Image = fliplr(rot90(double(rgb2gray(imread('M_letter.bmp')))/255,2));
h = imshow(Image);
hold on
Axis = axis(gca);
Axis([1 3]) = round(Axis([1 3]));
Axis([2 4]) = floor(Axis([2 4]))-1;
axis tight;
axis xy;
PlotGNFScaled(Model,Axis);
axis off

